//! Autogenerated by GenerateDef from src/aro/Attribute/names.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

tag: Tag,
properties: Properties,

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    aarch64_sve_pcs,
    aarch64_vector_pcs,
    access,
    alias,
    @"align",
    aligned,
    alloc_align,
    alloc_size,
    allocate,
    allocator,
    always_inline,
    appdomain,
    artificial,
    assume_aligned,
    cdecl,
    cleanup,
    code_seg,
    cold,
    common,
    @"const",
    constructor,
    copy,
    deprecated,
    designated_init,
    destructor,
    dllexport,
    dllimport,
    @"error",
    externally_visible,
    fallthrough,
    fastcall,
    flatten,
    format,
    format_arg,
    gnu_inline,
    hot,
    ifunc,
    interrupt,
    interrupt_handler,
    jitintrinsic,
    leaf,
    malloc,
    may_alias,
    maybe_unused,
    mode,
    ms_abi,
    naked,
    no_address_safety_analysis,
    no_icf,
    no_instrument_function,
    no_profile_instrument_function,
    no_reorder,
    no_sanitize,
    no_sanitize_address,
    no_sanitize_coverage,
    no_sanitize_thread,
    no_sanitize_undefined,
    no_split_stack,
    no_stack_limit,
    no_stack_protector,
    @"noalias",
    noclone,
    nocommon,
    nodiscard,
    noinit,
    @"noinline",
    noipa,
    nonnull,
    nonstring,
    noplt,
    @"noreturn",
    nothrow,
    @"packed",
    patchable_function_entry,
    pcs,
    persistent,
    process,
    pure,
    reproducible,
    restrict,
    retain,
    returns_nonnull,
    returns_twice,
    riscv_vector_cc,
    safebuffers,
    scalar_storage_order,
    section,
    selectany,
    sentinel,
    simd,
    spectre,
    stack_protect,
    stdcall,
    symver,
    sysv_abi,
    target,
    target_clones,
    thiscall,
    thread,
    tls_model,
    transparent_union,
    unavailable,
    uninitialized,
    unsequenced,
    unused,
    used,
    uuid,
    vector_size,
    vectorcall,
    visibility,
    warn_if_not_aligned,
    warn_unused_result,
    warning,
    weak,
    weakref,
    zero_call_used_regs,
};

const Self = @This();

pub fn fromName(name: []const u8) ?@This() {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) @This() {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 3;
pub const longest_name = 30;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(232);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct(u32) {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each name using a separate array.
    number: u8,
    /// If true, this node is the end of a valid name.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u14,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 21 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 27 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 30 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 32 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 34 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 37 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 38 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 39 },
    .{ .char = 'j', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 41 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 42 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 43 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 46 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 48 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 53 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 11, .child_index = 55 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 62 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 66 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 69 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 71 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 73 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 74 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 75 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 76 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 79 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 80 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 81 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 82 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 83 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 84 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 89 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 91 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 92 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 93 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 94 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 96 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 97 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 98 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 100 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 101 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 102 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 103 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 104 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 106 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 107 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 108 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 25, .child_index = 109 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 118 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 120 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 121 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 122 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 123 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 124 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 127 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 128 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 129 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 130 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 133 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 134 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 135 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 137 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 139 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 140 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 142 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 143 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 144 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 148 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 149 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 150 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 151 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 152 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 153 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 154 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 155 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 156 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 157 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 159 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 160 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 161 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 162 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 163 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 164 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 165 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 166 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 167 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 168 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 169 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 171 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 172 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 174 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 176 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 177 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 178 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 179 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 180 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 181 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 182 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 183 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 184 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 185 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 187 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 188 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 191 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 192 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 197 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 198 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 200 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 201 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 203 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 205 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 206 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 207 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 108 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 208 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 209 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 75 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 210 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 211 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 212 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 214 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 216 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 217 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 218 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 219 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 220 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 221 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 225 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 226 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 227 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 228 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 229 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 230 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 231 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 232 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 233 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 234 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 235 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 236 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 237 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 238 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 239 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 240 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 120 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 241 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 242 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 243 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 244 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 245 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 246 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 248 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 249 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 251 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 252 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 253 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 254 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 255 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 256 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 257 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 258 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 259 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 261 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 264 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 265 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 267 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 268 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 269 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 270 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 271 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 273 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 274 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 275 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 278 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 279 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 280 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 281 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 282 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 284 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 285 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 286 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 287 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 288 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 289 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 290 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 291 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 292 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 293 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 294 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 295 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 297 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 298 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 299 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 300 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 301 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 302 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 303 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 304 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 107 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 305 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 307 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 308 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 309 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 310 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 312 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 314 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 316 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 317 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 318 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 319 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 320 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 322 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 323 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 324 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 326 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 329 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 330 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 332 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 333 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 333 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 334 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 337 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 338 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 339 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 340 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 197 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 342 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 343 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 186 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 346 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 347 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 348 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 349 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 351 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 352 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 99 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 353 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 354 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 355 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 357 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 358 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 359 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 360 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 361 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 362 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 363 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 364 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 365 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 366 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 367 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 123 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 368 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 354 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 257 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 369 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 371 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 372 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 373 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 374 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 375 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 377 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 379 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 380 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 381 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 382 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 383 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 385 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 182 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 386 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 387 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 388 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 389 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 390 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 332 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 391 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 392 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 393 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 394 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 396 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 397 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 399 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 400 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 401 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 402 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 404 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 406 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 407 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 408 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 409 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 351 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 410 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 411 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 412 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 413 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 414 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 415 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 416 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 417 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 418 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 419 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 420 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 422 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 423 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 424 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 425 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 426 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 427 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 428 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 429 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 430 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 432 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 433 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 434 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 436 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 437 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 438 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 440 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 293 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 442 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 443 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 445 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 446 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 447 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 448 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 449 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 450 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 353 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 451 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 452 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 453 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 454 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 455 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 456 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 457 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 458 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 459 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 460 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 461 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 379 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 462 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 463 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 464 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 465 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 466 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 467 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 468 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 469 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 470 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 471 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 422 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 472 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 473 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 476 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 303 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 477 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 478 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 479 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 480 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 481 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 483 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 484 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 257 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 485 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 486 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 487 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 176 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 488 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 489 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 490 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 491 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 492 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 493 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 494 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 495 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 304 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 497 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 498 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 499 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 500 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 501 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 502 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 503 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 505 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 506 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 508 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 509 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 510 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 511 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 512 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 513 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 514 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 515 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 516 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 517 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 518 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 519 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 520 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 521 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 523 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 524 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 525 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 526 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 233 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 527 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 528 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 529 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 530 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 531 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 532 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 534 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 511 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 535 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 536 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 537 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 538 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 539 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 540 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 541 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 542 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 543 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 544 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 545 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 546 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 547 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 548 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 549 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 550 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 551 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 552 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 553 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 555 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 556 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 557 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 558 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 559 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 560 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 561 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 562 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 563 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 564 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 565 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 566 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 568 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 570 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 571 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 572 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 573 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 574 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 575 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 576 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 577 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 578 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 579 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 580 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 581 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 582 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 583 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 584 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 585 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 587 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 588 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 589 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 590 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 591 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 592 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 416 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 593 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 594 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 388 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 596 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 597 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 598 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 599 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 601 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 602 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 603 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 604 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 605 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 609 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 610 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 611 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 612 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 285 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 613 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 614 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 615 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 617 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 618 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 619 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 610 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 620 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 621 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 622 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 623 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 624 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 625 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 626 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 627 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 628 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 629 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 630 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 631 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 632 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 633 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 634 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 635 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 575 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 502 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 636 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 637 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 638 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 639 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 640 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 641 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 642 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 393 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 643 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 644 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 298 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 645 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 646 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 304 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 647 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 648 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 649 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 650 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 227 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 651 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 652 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 346 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 653 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 654 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 655 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 656 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 156 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 657 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 658 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 659 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 205 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 660 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 661 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 662 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 663 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 664 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 665 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 666 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 667 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 217 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 668 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 577 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 669 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 670 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 671 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 672 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 673 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 674 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 675 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 676 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 677 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 678 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 679 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
};
pub const data = blk: {
    @setEvalBranchQuota(812);
    break :blk [_]@This(){
        .{ .tag = .aarch64_sve_pcs, .properties = .{ .tag = .aarch64_sve_pcs, .gnu = true } },
        .{ .tag = .aarch64_vector_pcs, .properties = .{ .tag = .aarch64_vector_pcs, .gnu = true } },
        .{ .tag = .access, .properties = .{ .tag = .access, .gnu = true } },
        .{ .tag = .alias, .properties = .{ .tag = .alias, .gnu = true } },
        .{ .tag = .@"align", .properties = .{ .tag = .aligned, .declspec = true } },
        .{ .tag = .aligned, .properties = .{ .tag = .aligned, .gnu = true } },
        .{ .tag = .alloc_align, .properties = .{ .tag = .alloc_align, .gnu = true } },
        .{ .tag = .alloc_size, .properties = .{ .tag = .alloc_size, .gnu = true } },
        .{ .tag = .allocate, .properties = .{ .tag = .allocate, .declspec = true } },
        .{ .tag = .allocator, .properties = .{ .tag = .allocator, .declspec = true } },
        .{ .tag = .always_inline, .properties = .{ .tag = .always_inline, .gnu = true } },
        .{ .tag = .appdomain, .properties = .{ .tag = .appdomain, .declspec = true } },
        .{ .tag = .artificial, .properties = .{ .tag = .artificial, .gnu = true } },
        .{ .tag = .assume_aligned, .properties = .{ .tag = .assume_aligned, .gnu = true } },
        .{ .tag = .cdecl, .properties = .{ .tag = .cdecl, .gnu = true } },
        .{ .tag = .cleanup, .properties = .{ .tag = .cleanup, .gnu = true } },
        .{ .tag = .code_seg, .properties = .{ .tag = .code_seg, .declspec = true } },
        .{ .tag = .cold, .properties = .{ .tag = .cold, .gnu = true } },
        .{ .tag = .common, .properties = .{ .tag = .common, .gnu = true } },
        .{ .tag = .@"const", .properties = .{ .tag = .@"const", .gnu = true } },
        .{ .tag = .constructor, .properties = .{ .tag = .constructor, .gnu = true } },
        .{ .tag = .copy, .properties = .{ .tag = .copy, .gnu = true } },
        .{ .tag = .deprecated, .properties = .{ .tag = .deprecated, .c23 = true, .gnu = true, .declspec = true } },
        .{ .tag = .designated_init, .properties = .{ .tag = .designated_init, .gnu = true } },
        .{ .tag = .destructor, .properties = .{ .tag = .destructor, .gnu = true } },
        .{ .tag = .dllexport, .properties = .{ .tag = .dllexport, .declspec = true } },
        .{ .tag = .dllimport, .properties = .{ .tag = .dllimport, .declspec = true } },
        .{ .tag = .@"error", .properties = .{ .tag = .@"error", .gnu = true } },
        .{ .tag = .externally_visible, .properties = .{ .tag = .externally_visible, .gnu = true } },
        .{ .tag = .fallthrough, .properties = .{ .tag = .fallthrough, .c23 = true, .gnu = true } },
        .{ .tag = .fastcall, .properties = .{ .tag = .fastcall, .gnu = true } },
        .{ .tag = .flatten, .properties = .{ .tag = .flatten, .gnu = true } },
        .{ .tag = .format, .properties = .{ .tag = .format, .gnu = true } },
        .{ .tag = .format_arg, .properties = .{ .tag = .format_arg, .gnu = true } },
        .{ .tag = .gnu_inline, .properties = .{ .tag = .gnu_inline, .gnu = true } },
        .{ .tag = .hot, .properties = .{ .tag = .hot, .gnu = true } },
        .{ .tag = .ifunc, .properties = .{ .tag = .ifunc, .gnu = true } },
        .{ .tag = .interrupt, .properties = .{ .tag = .interrupt, .gnu = true } },
        .{ .tag = .interrupt_handler, .properties = .{ .tag = .interrupt_handler, .gnu = true } },
        .{ .tag = .jitintrinsic, .properties = .{ .tag = .jitintrinsic, .declspec = true } },
        .{ .tag = .leaf, .properties = .{ .tag = .leaf, .gnu = true } },
        .{ .tag = .malloc, .properties = .{ .tag = .malloc, .gnu = true } },
        .{ .tag = .may_alias, .properties = .{ .tag = .may_alias, .gnu = true } },
        .{ .tag = .maybe_unused, .properties = .{ .tag = .unused, .c23 = true } },
        .{ .tag = .mode, .properties = .{ .tag = .mode, .gnu = true } },
        .{ .tag = .ms_abi, .properties = .{ .tag = .ms_abi, .gnu = true } },
        .{ .tag = .naked, .properties = .{ .tag = .naked, .declspec = true } },
        .{ .tag = .no_address_safety_analysis, .properties = .{ .tag = .no_address_safety_analysis, .gnu = true } },
        .{ .tag = .no_icf, .properties = .{ .tag = .no_icf, .gnu = true } },
        .{ .tag = .no_instrument_function, .properties = .{ .tag = .no_instrument_function, .gnu = true } },
        .{ .tag = .no_profile_instrument_function, .properties = .{ .tag = .no_profile_instrument_function, .gnu = true } },
        .{ .tag = .no_reorder, .properties = .{ .tag = .no_reorder, .gnu = true } },
        .{ .tag = .no_sanitize, .properties = .{ .tag = .no_sanitize, .gnu = true } },
        .{ .tag = .no_sanitize_address, .properties = .{ .tag = .no_sanitize_address, .gnu = true, .declspec = true } },
        .{ .tag = .no_sanitize_coverage, .properties = .{ .tag = .no_sanitize_coverage, .gnu = true } },
        .{ .tag = .no_sanitize_thread, .properties = .{ .tag = .no_sanitize_thread, .gnu = true } },
        .{ .tag = .no_sanitize_undefined, .properties = .{ .tag = .no_sanitize_undefined, .gnu = true } },
        .{ .tag = .no_split_stack, .properties = .{ .tag = .no_split_stack, .gnu = true } },
        .{ .tag = .no_stack_limit, .properties = .{ .tag = .no_stack_limit, .gnu = true } },
        .{ .tag = .no_stack_protector, .properties = .{ .tag = .no_stack_protector, .gnu = true } },
        .{ .tag = .@"noalias", .properties = .{ .tag = .@"noalias", .declspec = true } },
        .{ .tag = .noclone, .properties = .{ .tag = .noclone, .gnu = true } },
        .{ .tag = .nocommon, .properties = .{ .tag = .nocommon, .gnu = true } },
        .{ .tag = .nodiscard, .properties = .{ .tag = .nodiscard, .c23 = true } },
        .{ .tag = .noinit, .properties = .{ .tag = .noinit, .gnu = true } },
        .{ .tag = .@"noinline", .properties = .{ .tag = .@"noinline", .gnu = true, .declspec = true } },
        .{ .tag = .noipa, .properties = .{ .tag = .noipa, .gnu = true } },
        .{ .tag = .nonnull, .properties = .{ .tag = .nonnull, .gnu = true } },
        .{ .tag = .nonstring, .properties = .{ .tag = .nonstring, .gnu = true } },
        .{ .tag = .noplt, .properties = .{ .tag = .noplt, .gnu = true } },
        .{ .tag = .@"noreturn", .properties = .{ .tag = .@"noreturn", .c23 = true, .gnu = true, .declspec = true } },
        .{ .tag = .nothrow, .properties = .{ .tag = .nothrow, .gnu = true } },
        .{ .tag = .@"packed", .properties = .{ .tag = .@"packed", .gnu = true } },
        .{ .tag = .patchable_function_entry, .properties = .{ .tag = .patchable_function_entry, .gnu = true } },
        .{ .tag = .pcs, .properties = .{ .tag = .pcs, .gnu = true } },
        .{ .tag = .persistent, .properties = .{ .tag = .persistent, .gnu = true } },
        .{ .tag = .process, .properties = .{ .tag = .process, .declspec = true } },
        .{ .tag = .pure, .properties = .{ .tag = .pure, .gnu = true } },
        .{ .tag = .reproducible, .properties = .{ .tag = .reproducible, .c23 = true } },
        .{ .tag = .restrict, .properties = .{ .tag = .restrict, .declspec = true } },
        .{ .tag = .retain, .properties = .{ .tag = .retain, .gnu = true } },
        .{ .tag = .returns_nonnull, .properties = .{ .tag = .returns_nonnull, .gnu = true } },
        .{ .tag = .returns_twice, .properties = .{ .tag = .returns_twice, .gnu = true } },
        .{ .tag = .riscv_vector_cc, .properties = .{ .tag = .riscv_vector_cc, .gnu = true } },
        .{ .tag = .safebuffers, .properties = .{ .tag = .safebuffers, .declspec = true } },
        .{ .tag = .scalar_storage_order, .properties = .{ .tag = .scalar_storage_order, .gnu = true } },
        .{ .tag = .section, .properties = .{ .tag = .section, .gnu = true } },
        .{ .tag = .selectany, .properties = .{ .tag = .selectany, .declspec = true } },
        .{ .tag = .sentinel, .properties = .{ .tag = .sentinel, .gnu = true } },
        .{ .tag = .simd, .properties = .{ .tag = .simd, .gnu = true } },
        .{ .tag = .spectre, .properties = .{ .tag = .spectre, .declspec = true } },
        .{ .tag = .stack_protect, .properties = .{ .tag = .stack_protect, .gnu = true } },
        .{ .tag = .stdcall, .properties = .{ .tag = .stdcall, .gnu = true } },
        .{ .tag = .symver, .properties = .{ .tag = .symver, .gnu = true } },
        .{ .tag = .sysv_abi, .properties = .{ .tag = .sysv_abi, .gnu = true } },
        .{ .tag = .target, .properties = .{ .tag = .target, .gnu = true } },
        .{ .tag = .target_clones, .properties = .{ .tag = .target_clones, .gnu = true } },
        .{ .tag = .thiscall, .properties = .{ .tag = .thiscall, .gnu = true } },
        .{ .tag = .thread, .properties = .{ .tag = .thread, .declspec = true } },
        .{ .tag = .tls_model, .properties = .{ .tag = .tls_model, .gnu = true } },
        .{ .tag = .transparent_union, .properties = .{ .tag = .transparent_union, .gnu = true } },
        .{ .tag = .unavailable, .properties = .{ .tag = .unavailable, .gnu = true } },
        .{ .tag = .uninitialized, .properties = .{ .tag = .uninitialized, .gnu = true } },
        .{ .tag = .unsequenced, .properties = .{ .tag = .unsequenced, .c23 = true } },
        .{ .tag = .unused, .properties = .{ .tag = .unused, .gnu = true } },
        .{ .tag = .used, .properties = .{ .tag = .used, .gnu = true } },
        .{ .tag = .uuid, .properties = .{ .tag = .uuid, .declspec = true } },
        .{ .tag = .vector_size, .properties = .{ .tag = .vector_size, .gnu = true } },
        .{ .tag = .vectorcall, .properties = .{ .tag = .vectorcall, .gnu = true } },
        .{ .tag = .visibility, .properties = .{ .tag = .visibility, .gnu = true } },
        .{ .tag = .warn_if_not_aligned, .properties = .{ .tag = .warn_if_not_aligned, .gnu = true } },
        .{ .tag = .warn_unused_result, .properties = .{ .tag = .warn_unused_result, .gnu = true } },
        .{ .tag = .warning, .properties = .{ .tag = .warning, .gnu = true } },
        .{ .tag = .weak, .properties = .{ .tag = .weak, .gnu = true } },
        .{ .tag = .weakref, .properties = .{ .tag = .weakref, .gnu = true } },
        .{ .tag = .zero_call_used_regs, .properties = .{ .tag = .zero_call_used_regs, .gnu = true } },
    };
};
};
}
