//! Autogenerated by GenerateDef from src/aro/Builtins/nvptx.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    __bmma_m8n8k128_ld_a_b1,
    __bmma_m8n8k128_ld_b_b1,
    __bmma_m8n8k128_ld_c,
    __bmma_m8n8k128_mma_and_popc_b1,
    __bmma_m8n8k128_mma_xor_popc_b1,
    __bmma_m8n8k128_st_c_i32,
    __builtin_ptx_get_image_channel_data_typei_,
    __builtin_ptx_get_image_channel_orderi_,
    __builtin_ptx_get_image_depthi_,
    __builtin_ptx_get_image_heighti_,
    __builtin_ptx_get_image_widthi_,
    __builtin_ptx_read_image2Dff_,
    __builtin_ptx_read_image2Dfi_,
    __builtin_ptx_read_image2Dif_,
    __builtin_ptx_read_image2Dii_,
    __builtin_ptx_read_image3Dff_,
    __builtin_ptx_read_image3Dfi_,
    __builtin_ptx_read_image3Dif_,
    __builtin_ptx_read_image3Dii_,
    __builtin_ptx_write_image2Df_,
    __builtin_ptx_write_image2Di_,
    __builtin_ptx_write_image2Dui_,
    __dmma_m8n8k4_ld_a,
    __dmma_m8n8k4_ld_b,
    __dmma_m8n8k4_ld_c,
    __dmma_m8n8k4_mma_f64,
    __dmma_m8n8k4_st_c_f64,
    __hmma_m16n16k16_ld_a,
    __hmma_m16n16k16_ld_b,
    __hmma_m16n16k16_ld_c_f16,
    __hmma_m16n16k16_ld_c_f32,
    __hmma_m16n16k16_mma_f16f16,
    __hmma_m16n16k16_mma_f16f32,
    __hmma_m16n16k16_mma_f32f16,
    __hmma_m16n16k16_mma_f32f32,
    __hmma_m16n16k16_st_c_f16,
    __hmma_m16n16k16_st_c_f32,
    __hmma_m32n8k16_ld_a,
    __hmma_m32n8k16_ld_b,
    __hmma_m32n8k16_ld_c_f16,
    __hmma_m32n8k16_ld_c_f32,
    __hmma_m32n8k16_mma_f16f16,
    __hmma_m32n8k16_mma_f16f32,
    __hmma_m32n8k16_mma_f32f16,
    __hmma_m32n8k16_mma_f32f32,
    __hmma_m32n8k16_st_c_f16,
    __hmma_m32n8k16_st_c_f32,
    __hmma_m8n32k16_ld_a,
    __hmma_m8n32k16_ld_b,
    __hmma_m8n32k16_ld_c_f16,
    __hmma_m8n32k16_ld_c_f32,
    __hmma_m8n32k16_mma_f16f16,
    __hmma_m8n32k16_mma_f16f32,
    __hmma_m8n32k16_mma_f32f16,
    __hmma_m8n32k16_mma_f32f32,
    __hmma_m8n32k16_st_c_f16,
    __hmma_m8n32k16_st_c_f32,
    __imma_m16n16k16_ld_a_s8,
    __imma_m16n16k16_ld_a_u8,
    __imma_m16n16k16_ld_b_s8,
    __imma_m16n16k16_ld_b_u8,
    __imma_m16n16k16_ld_c,
    __imma_m16n16k16_mma_s8,
    __imma_m16n16k16_mma_u8,
    __imma_m16n16k16_st_c_i32,
    __imma_m32n8k16_ld_a_s8,
    __imma_m32n8k16_ld_a_u8,
    __imma_m32n8k16_ld_b_s8,
    __imma_m32n8k16_ld_b_u8,
    __imma_m32n8k16_ld_c,
    __imma_m32n8k16_mma_s8,
    __imma_m32n8k16_mma_u8,
    __imma_m32n8k16_st_c_i32,
    __imma_m8n32k16_ld_a_s8,
    __imma_m8n32k16_ld_a_u8,
    __imma_m8n32k16_ld_b_s8,
    __imma_m8n32k16_ld_b_u8,
    __imma_m8n32k16_ld_c,
    __imma_m8n32k16_mma_s8,
    __imma_m8n32k16_mma_u8,
    __imma_m8n32k16_st_c_i32,
    __imma_m8n8k32_ld_a_s4,
    __imma_m8n8k32_ld_a_u4,
    __imma_m8n8k32_ld_b_s4,
    __imma_m8n8k32_ld_b_u4,
    __imma_m8n8k32_ld_c,
    __imma_m8n8k32_mma_s4,
    __imma_m8n8k32_mma_u4,
    __imma_m8n8k32_st_c_i32,
    __mma_bf16_m16n16k16_ld_a,
    __mma_bf16_m16n16k16_ld_b,
    __mma_bf16_m16n16k16_mma_f32,
    __mma_bf16_m32n8k16_ld_a,
    __mma_bf16_m32n8k16_ld_b,
    __mma_bf16_m32n8k16_mma_f32,
    __mma_bf16_m8n32k16_ld_a,
    __mma_bf16_m8n32k16_ld_b,
    __mma_bf16_m8n32k16_mma_f32,
    __mma_m16n16k8_st_c_f32,
    __mma_tf32_m16n16k8_ld_a,
    __mma_tf32_m16n16k8_ld_b,
    __mma_tf32_m16n16k8_ld_c,
    __mma_tf32_m16n16k8_mma_f32,
    __nvvm_abs_bf16,
    __nvvm_abs_bf16x2,
    __nvvm_activemask,
    __nvvm_add_rm_d,
    __nvvm_add_rm_f,
    __nvvm_add_rm_ftz_f,
    __nvvm_add_rn_d,
    __nvvm_add_rn_f,
    __nvvm_add_rn_ftz_f,
    __nvvm_add_rp_d,
    __nvvm_add_rp_f,
    __nvvm_add_rp_ftz_f,
    __nvvm_add_rz_d,
    __nvvm_add_rz_f,
    __nvvm_add_rz_ftz_f,
    __nvvm_atom_add_gen_d,
    __nvvm_atom_add_gen_f,
    __nvvm_atom_add_gen_i,
    __nvvm_atom_add_gen_l,
    __nvvm_atom_add_gen_ll,
    __nvvm_atom_and_gen_i,
    __nvvm_atom_and_gen_l,
    __nvvm_atom_and_gen_ll,
    __nvvm_atom_cas_gen_i,
    __nvvm_atom_cas_gen_l,
    __nvvm_atom_cas_gen_ll,
    __nvvm_atom_cas_gen_us,
    __nvvm_atom_cta_add_gen_d,
    __nvvm_atom_cta_add_gen_f,
    __nvvm_atom_cta_add_gen_i,
    __nvvm_atom_cta_add_gen_l,
    __nvvm_atom_cta_add_gen_ll,
    __nvvm_atom_cta_and_gen_i,
    __nvvm_atom_cta_and_gen_l,
    __nvvm_atom_cta_and_gen_ll,
    __nvvm_atom_cta_cas_gen_i,
    __nvvm_atom_cta_cas_gen_l,
    __nvvm_atom_cta_cas_gen_ll,
    __nvvm_atom_cta_cas_gen_us,
    __nvvm_atom_cta_dec_gen_ui,
    __nvvm_atom_cta_inc_gen_ui,
    __nvvm_atom_cta_max_gen_i,
    __nvvm_atom_cta_max_gen_l,
    __nvvm_atom_cta_max_gen_ll,
    __nvvm_atom_cta_max_gen_ui,
    __nvvm_atom_cta_max_gen_ul,
    __nvvm_atom_cta_max_gen_ull,
    __nvvm_atom_cta_min_gen_i,
    __nvvm_atom_cta_min_gen_l,
    __nvvm_atom_cta_min_gen_ll,
    __nvvm_atom_cta_min_gen_ui,
    __nvvm_atom_cta_min_gen_ul,
    __nvvm_atom_cta_min_gen_ull,
    __nvvm_atom_cta_or_gen_i,
    __nvvm_atom_cta_or_gen_l,
    __nvvm_atom_cta_or_gen_ll,
    __nvvm_atom_cta_xchg_gen_i,
    __nvvm_atom_cta_xchg_gen_l,
    __nvvm_atom_cta_xchg_gen_ll,
    __nvvm_atom_cta_xor_gen_i,
    __nvvm_atom_cta_xor_gen_l,
    __nvvm_atom_cta_xor_gen_ll,
    __nvvm_atom_dec_gen_ui,
    __nvvm_atom_inc_gen_ui,
    __nvvm_atom_max_gen_i,
    __nvvm_atom_max_gen_l,
    __nvvm_atom_max_gen_ll,
    __nvvm_atom_max_gen_ui,
    __nvvm_atom_max_gen_ul,
    __nvvm_atom_max_gen_ull,
    __nvvm_atom_min_gen_i,
    __nvvm_atom_min_gen_l,
    __nvvm_atom_min_gen_ll,
    __nvvm_atom_min_gen_ui,
    __nvvm_atom_min_gen_ul,
    __nvvm_atom_min_gen_ull,
    __nvvm_atom_or_gen_i,
    __nvvm_atom_or_gen_l,
    __nvvm_atom_or_gen_ll,
    __nvvm_atom_sub_gen_i,
    __nvvm_atom_sub_gen_l,
    __nvvm_atom_sub_gen_ll,
    __nvvm_atom_sys_add_gen_d,
    __nvvm_atom_sys_add_gen_f,
    __nvvm_atom_sys_add_gen_i,
    __nvvm_atom_sys_add_gen_l,
    __nvvm_atom_sys_add_gen_ll,
    __nvvm_atom_sys_and_gen_i,
    __nvvm_atom_sys_and_gen_l,
    __nvvm_atom_sys_and_gen_ll,
    __nvvm_atom_sys_cas_gen_i,
    __nvvm_atom_sys_cas_gen_l,
    __nvvm_atom_sys_cas_gen_ll,
    __nvvm_atom_sys_cas_gen_us,
    __nvvm_atom_sys_dec_gen_ui,
    __nvvm_atom_sys_inc_gen_ui,
    __nvvm_atom_sys_max_gen_i,
    __nvvm_atom_sys_max_gen_l,
    __nvvm_atom_sys_max_gen_ll,
    __nvvm_atom_sys_max_gen_ui,
    __nvvm_atom_sys_max_gen_ul,
    __nvvm_atom_sys_max_gen_ull,
    __nvvm_atom_sys_min_gen_i,
    __nvvm_atom_sys_min_gen_l,
    __nvvm_atom_sys_min_gen_ll,
    __nvvm_atom_sys_min_gen_ui,
    __nvvm_atom_sys_min_gen_ul,
    __nvvm_atom_sys_min_gen_ull,
    __nvvm_atom_sys_or_gen_i,
    __nvvm_atom_sys_or_gen_l,
    __nvvm_atom_sys_or_gen_ll,
    __nvvm_atom_sys_xchg_gen_i,
    __nvvm_atom_sys_xchg_gen_l,
    __nvvm_atom_sys_xchg_gen_ll,
    __nvvm_atom_sys_xor_gen_i,
    __nvvm_atom_sys_xor_gen_l,
    __nvvm_atom_sys_xor_gen_ll,
    __nvvm_atom_xchg_gen_i,
    __nvvm_atom_xchg_gen_l,
    __nvvm_atom_xchg_gen_ll,
    __nvvm_atom_xor_gen_i,
    __nvvm_atom_xor_gen_l,
    __nvvm_atom_xor_gen_ll,
    __nvvm_bar0_and,
    __nvvm_bar0_or,
    __nvvm_bar0_popc,
    __nvvm_bar_sync,
    __nvvm_bar_warp_sync,
    __nvvm_barrier_cluster_arrive,
    __nvvm_barrier_cluster_arrive_relaxed,
    __nvvm_barrier_cluster_wait,
    __nvvm_barrier_sync,
    __nvvm_barrier_sync_cnt,
    __nvvm_bf16x2_to_ue8m0x2_rp,
    __nvvm_bf16x2_to_ue8m0x2_rp_satfinite,
    __nvvm_bf16x2_to_ue8m0x2_rz,
    __nvvm_bf16x2_to_ue8m0x2_rz_satfinite,
    __nvvm_ceil_d,
    __nvvm_ceil_f,
    __nvvm_ceil_ftz_f,
    __nvvm_compiler_error,
    __nvvm_compiler_warn,
    __nvvm_cos_approx_f,
    __nvvm_cos_approx_ftz_f,
    __nvvm_cp_async_ca_shared_global_16,
    __nvvm_cp_async_ca_shared_global_4,
    __nvvm_cp_async_ca_shared_global_8,
    __nvvm_cp_async_cg_shared_global_16,
    __nvvm_cp_async_commit_group,
    __nvvm_cp_async_mbarrier_arrive,
    __nvvm_cp_async_mbarrier_arrive_noinc,
    __nvvm_cp_async_mbarrier_arrive_noinc_shared,
    __nvvm_cp_async_mbarrier_arrive_shared,
    __nvvm_cp_async_wait_all,
    __nvvm_cp_async_wait_group,
    __nvvm_d2f_rm,
    __nvvm_d2f_rm_ftz,
    __nvvm_d2f_rn,
    __nvvm_d2f_rn_ftz,
    __nvvm_d2f_rp,
    __nvvm_d2f_rp_ftz,
    __nvvm_d2f_rz,
    __nvvm_d2f_rz_ftz,
    __nvvm_d2i_hi,
    __nvvm_d2i_lo,
    __nvvm_d2i_rm,
    __nvvm_d2i_rn,
    __nvvm_d2i_rp,
    __nvvm_d2i_rz,
    __nvvm_d2ll_rm,
    __nvvm_d2ll_rn,
    __nvvm_d2ll_rp,
    __nvvm_d2ll_rz,
    __nvvm_d2ui_rm,
    __nvvm_d2ui_rn,
    __nvvm_d2ui_rp,
    __nvvm_d2ui_rz,
    __nvvm_d2ull_rm,
    __nvvm_d2ull_rn,
    __nvvm_d2ull_rp,
    __nvvm_d2ull_rz,
    __nvvm_div_approx_f,
    __nvvm_div_approx_ftz_f,
    __nvvm_div_rm_d,
    __nvvm_div_rm_f,
    __nvvm_div_rm_ftz_f,
    __nvvm_div_rn_d,
    __nvvm_div_rn_f,
    __nvvm_div_rn_ftz_f,
    __nvvm_div_rp_d,
    __nvvm_div_rp_f,
    __nvvm_div_rp_ftz_f,
    __nvvm_div_rz_d,
    __nvvm_div_rz_f,
    __nvvm_div_rz_ftz_f,
    __nvvm_e2m1x2_to_f16x2_rn,
    __nvvm_e2m1x2_to_f16x2_rn_relu,
    __nvvm_e2m3x2_to_f16x2_rn,
    __nvvm_e2m3x2_to_f16x2_rn_relu,
    __nvvm_e3m2x2_to_f16x2_rn,
    __nvvm_e3m2x2_to_f16x2_rn_relu,
    __nvvm_e4m3x2_to_f16x2_rn,
    __nvvm_e4m3x2_to_f16x2_rn_relu,
    __nvvm_e5m2x2_to_f16x2_rn,
    __nvvm_e5m2x2_to_f16x2_rn_relu,
    __nvvm_ex2_approx_d,
    __nvvm_ex2_approx_f,
    __nvvm_ex2_approx_f16,
    __nvvm_ex2_approx_f16x2,
    __nvvm_ex2_approx_ftz_f,
    __nvvm_exit,
    __nvvm_f16x2_to_e4m3x2_rn,
    __nvvm_f16x2_to_e4m3x2_rn_relu,
    __nvvm_f16x2_to_e5m2x2_rn,
    __nvvm_f16x2_to_e5m2x2_rn_relu,
    __nvvm_f2bf16_rn,
    __nvvm_f2bf16_rn_relu,
    __nvvm_f2bf16_rz,
    __nvvm_f2bf16_rz_relu,
    __nvvm_f2h_rn,
    __nvvm_f2h_rn_ftz,
    __nvvm_f2i_rm,
    __nvvm_f2i_rm_ftz,
    __nvvm_f2i_rn,
    __nvvm_f2i_rn_ftz,
    __nvvm_f2i_rp,
    __nvvm_f2i_rp_ftz,
    __nvvm_f2i_rz,
    __nvvm_f2i_rz_ftz,
    __nvvm_f2ll_rm,
    __nvvm_f2ll_rm_ftz,
    __nvvm_f2ll_rn,
    __nvvm_f2ll_rn_ftz,
    __nvvm_f2ll_rp,
    __nvvm_f2ll_rp_ftz,
    __nvvm_f2ll_rz,
    __nvvm_f2ll_rz_ftz,
    __nvvm_f2tf32_rn,
    __nvvm_f2tf32_rn_relu,
    __nvvm_f2tf32_rn_relu_satfinite,
    __nvvm_f2tf32_rn_satfinite,
    __nvvm_f2tf32_rna,
    __nvvm_f2tf32_rna_satfinite,
    __nvvm_f2tf32_rz,
    __nvvm_f2tf32_rz_relu,
    __nvvm_f2tf32_rz_relu_satfinite,
    __nvvm_f2tf32_rz_satfinite,
    __nvvm_f2ui_rm,
    __nvvm_f2ui_rm_ftz,
    __nvvm_f2ui_rn,
    __nvvm_f2ui_rn_ftz,
    __nvvm_f2ui_rp,
    __nvvm_f2ui_rp_ftz,
    __nvvm_f2ui_rz,
    __nvvm_f2ui_rz_ftz,
    __nvvm_f2ull_rm,
    __nvvm_f2ull_rm_ftz,
    __nvvm_f2ull_rn,
    __nvvm_f2ull_rn_ftz,
    __nvvm_f2ull_rp,
    __nvvm_f2ull_rp_ftz,
    __nvvm_f2ull_rz,
    __nvvm_f2ull_rz_ftz,
    __nvvm_fabs_d,
    __nvvm_fabs_f,
    __nvvm_fabs_f16,
    __nvvm_fabs_f16x2,
    __nvvm_fabs_ftz_f,
    __nvvm_fabs_ftz_f16,
    __nvvm_fabs_ftz_f16x2,
    __nvvm_fence_sc_cluster,
    __nvvm_ff2bf16x2_rn,
    __nvvm_ff2bf16x2_rn_relu,
    __nvvm_ff2bf16x2_rz,
    __nvvm_ff2bf16x2_rz_relu,
    __nvvm_ff2f16x2_rn,
    __nvvm_ff2f16x2_rn_relu,
    __nvvm_ff2f16x2_rz,
    __nvvm_ff2f16x2_rz_relu,
    __nvvm_ff_to_e2m1x2_rn_relu_satfinite,
    __nvvm_ff_to_e2m1x2_rn_satfinite,
    __nvvm_ff_to_e2m3x2_rn_relu_satfinite,
    __nvvm_ff_to_e2m3x2_rn_satfinite,
    __nvvm_ff_to_e3m2x2_rn_relu_satfinite,
    __nvvm_ff_to_e3m2x2_rn_satfinite,
    __nvvm_ff_to_e4m3x2_rn,
    __nvvm_ff_to_e4m3x2_rn_relu,
    __nvvm_ff_to_e5m2x2_rn,
    __nvvm_ff_to_e5m2x2_rn_relu,
    __nvvm_ff_to_ue8m0x2_rp,
    __nvvm_ff_to_ue8m0x2_rp_satfinite,
    __nvvm_ff_to_ue8m0x2_rz,
    __nvvm_ff_to_ue8m0x2_rz_satfinite,
    __nvvm_floor_d,
    __nvvm_floor_f,
    __nvvm_floor_ftz_f,
    __nvvm_fma_rm_d,
    __nvvm_fma_rm_f,
    __nvvm_fma_rm_ftz_f,
    __nvvm_fma_rn_bf16,
    __nvvm_fma_rn_bf16x2,
    __nvvm_fma_rn_d,
    __nvvm_fma_rn_f,
    __nvvm_fma_rn_f16,
    __nvvm_fma_rn_f16x2,
    __nvvm_fma_rn_ftz_f,
    __nvvm_fma_rn_ftz_f16,
    __nvvm_fma_rn_ftz_f16x2,
    __nvvm_fma_rn_ftz_relu_f16,
    __nvvm_fma_rn_ftz_relu_f16x2,
    __nvvm_fma_rn_ftz_sat_f16,
    __nvvm_fma_rn_ftz_sat_f16x2,
    __nvvm_fma_rn_relu_bf16,
    __nvvm_fma_rn_relu_bf16x2,
    __nvvm_fma_rn_relu_f16,
    __nvvm_fma_rn_relu_f16x2,
    __nvvm_fma_rn_sat_f16,
    __nvvm_fma_rn_sat_f16x2,
    __nvvm_fma_rp_d,
    __nvvm_fma_rp_f,
    __nvvm_fma_rp_ftz_f,
    __nvvm_fma_rz_d,
    __nvvm_fma_rz_f,
    __nvvm_fma_rz_ftz_f,
    __nvvm_fmax_bf16,
    __nvvm_fmax_bf16x2,
    __nvvm_fmax_d,
    __nvvm_fmax_f,
    __nvvm_fmax_f16,
    __nvvm_fmax_f16x2,
    __nvvm_fmax_ftz_bf16,
    __nvvm_fmax_ftz_bf16x2,
    __nvvm_fmax_ftz_f,
    __nvvm_fmax_ftz_f16,
    __nvvm_fmax_ftz_f16x2,
    __nvvm_fmax_ftz_nan_bf16,
    __nvvm_fmax_ftz_nan_bf16x2,
    __nvvm_fmax_ftz_nan_f,
    __nvvm_fmax_ftz_nan_f16,
    __nvvm_fmax_ftz_nan_f16x2,
    __nvvm_fmax_ftz_nan_xorsign_abs_f,
    __nvvm_fmax_ftz_nan_xorsign_abs_f16,
    __nvvm_fmax_ftz_nan_xorsign_abs_f16x2,
    __nvvm_fmax_ftz_xorsign_abs_f,
    __nvvm_fmax_ftz_xorsign_abs_f16,
    __nvvm_fmax_ftz_xorsign_abs_f16x2,
    __nvvm_fmax_nan_bf16,
    __nvvm_fmax_nan_bf16x2,
    __nvvm_fmax_nan_f,
    __nvvm_fmax_nan_f16,
    __nvvm_fmax_nan_f16x2,
    __nvvm_fmax_nan_xorsign_abs_bf16,
    __nvvm_fmax_nan_xorsign_abs_bf16x2,
    __nvvm_fmax_nan_xorsign_abs_f,
    __nvvm_fmax_nan_xorsign_abs_f16,
    __nvvm_fmax_nan_xorsign_abs_f16x2,
    __nvvm_fmax_xorsign_abs_bf16,
    __nvvm_fmax_xorsign_abs_bf16x2,
    __nvvm_fmax_xorsign_abs_f,
    __nvvm_fmax_xorsign_abs_f16,
    __nvvm_fmax_xorsign_abs_f16x2,
    __nvvm_fmin_bf16,
    __nvvm_fmin_bf16x2,
    __nvvm_fmin_d,
    __nvvm_fmin_f,
    __nvvm_fmin_f16,
    __nvvm_fmin_f16x2,
    __nvvm_fmin_ftz_bf16,
    __nvvm_fmin_ftz_bf16x2,
    __nvvm_fmin_ftz_f,
    __nvvm_fmin_ftz_f16,
    __nvvm_fmin_ftz_f16x2,
    __nvvm_fmin_ftz_nan_bf16,
    __nvvm_fmin_ftz_nan_bf16x2,
    __nvvm_fmin_ftz_nan_f,
    __nvvm_fmin_ftz_nan_f16,
    __nvvm_fmin_ftz_nan_f16x2,
    __nvvm_fmin_ftz_nan_xorsign_abs_f,
    __nvvm_fmin_ftz_nan_xorsign_abs_f16,
    __nvvm_fmin_ftz_nan_xorsign_abs_f16x2,
    __nvvm_fmin_ftz_xorsign_abs_f,
    __nvvm_fmin_ftz_xorsign_abs_f16,
    __nvvm_fmin_ftz_xorsign_abs_f16x2,
    __nvvm_fmin_nan_bf16,
    __nvvm_fmin_nan_bf16x2,
    __nvvm_fmin_nan_f,
    __nvvm_fmin_nan_f16,
    __nvvm_fmin_nan_f16x2,
    __nvvm_fmin_nan_xorsign_abs_bf16,
    __nvvm_fmin_nan_xorsign_abs_bf16x2,
    __nvvm_fmin_nan_xorsign_abs_f,
    __nvvm_fmin_nan_xorsign_abs_f16,
    __nvvm_fmin_nan_xorsign_abs_f16x2,
    __nvvm_fmin_xorsign_abs_bf16,
    __nvvm_fmin_xorsign_abs_bf16x2,
    __nvvm_fmin_xorsign_abs_f,
    __nvvm_fmin_xorsign_abs_f16,
    __nvvm_fmin_xorsign_abs_f16x2,
    __nvvm_fns,
    __nvvm_getctarank,
    __nvvm_getctarank_shared_cluster,
    __nvvm_i2d_rm,
    __nvvm_i2d_rn,
    __nvvm_i2d_rp,
    __nvvm_i2d_rz,
    __nvvm_i2f_rm,
    __nvvm_i2f_rn,
    __nvvm_i2f_rp,
    __nvvm_i2f_rz,
    __nvvm_is_explicit_cluster,
    __nvvm_isspacep_const,
    __nvvm_isspacep_global,
    __nvvm_isspacep_local,
    __nvvm_isspacep_shared,
    __nvvm_isspacep_shared_cluster,
    __nvvm_ldg_c,
    __nvvm_ldg_c2,
    __nvvm_ldg_c4,
    __nvvm_ldg_d,
    __nvvm_ldg_d2,
    __nvvm_ldg_f,
    __nvvm_ldg_f2,
    __nvvm_ldg_f4,
    __nvvm_ldg_h,
    __nvvm_ldg_h2,
    __nvvm_ldg_i,
    __nvvm_ldg_i2,
    __nvvm_ldg_i4,
    __nvvm_ldg_l,
    __nvvm_ldg_l2,
    __nvvm_ldg_ll,
    __nvvm_ldg_ll2,
    __nvvm_ldg_s,
    __nvvm_ldg_s2,
    __nvvm_ldg_s4,
    __nvvm_ldg_sc,
    __nvvm_ldg_sc2,
    __nvvm_ldg_sc4,
    __nvvm_ldg_uc,
    __nvvm_ldg_uc2,
    __nvvm_ldg_uc4,
    __nvvm_ldg_ui,
    __nvvm_ldg_ui2,
    __nvvm_ldg_ui4,
    __nvvm_ldg_ul,
    __nvvm_ldg_ul2,
    __nvvm_ldg_ull,
    __nvvm_ldg_ull2,
    __nvvm_ldg_us,
    __nvvm_ldg_us2,
    __nvvm_ldg_us4,
    __nvvm_ldu_c,
    __nvvm_ldu_c2,
    __nvvm_ldu_c4,
    __nvvm_ldu_d,
    __nvvm_ldu_d2,
    __nvvm_ldu_f,
    __nvvm_ldu_f2,
    __nvvm_ldu_f4,
    __nvvm_ldu_h,
    __nvvm_ldu_h2,
    __nvvm_ldu_i,
    __nvvm_ldu_i2,
    __nvvm_ldu_i4,
    __nvvm_ldu_l,
    __nvvm_ldu_l2,
    __nvvm_ldu_ll,
    __nvvm_ldu_ll2,
    __nvvm_ldu_s,
    __nvvm_ldu_s2,
    __nvvm_ldu_s4,
    __nvvm_ldu_sc,
    __nvvm_ldu_sc2,
    __nvvm_ldu_sc4,
    __nvvm_ldu_uc,
    __nvvm_ldu_uc2,
    __nvvm_ldu_uc4,
    __nvvm_ldu_ui,
    __nvvm_ldu_ui2,
    __nvvm_ldu_ui4,
    __nvvm_ldu_ul,
    __nvvm_ldu_ul2,
    __nvvm_ldu_ull,
    __nvvm_ldu_ull2,
    __nvvm_ldu_us,
    __nvvm_ldu_us2,
    __nvvm_ldu_us4,
    __nvvm_lg2_approx_d,
    __nvvm_lg2_approx_f,
    __nvvm_lg2_approx_ftz_f,
    __nvvm_ll2d_rm,
    __nvvm_ll2d_rn,
    __nvvm_ll2d_rp,
    __nvvm_ll2d_rz,
    __nvvm_ll2f_rm,
    __nvvm_ll2f_rn,
    __nvvm_ll2f_rp,
    __nvvm_ll2f_rz,
    __nvvm_lohi_i2d,
    __nvvm_mapa,
    __nvvm_mapa_shared_cluster,
    __nvvm_match_all_sync_i32p,
    __nvvm_match_all_sync_i64p,
    __nvvm_match_any_sync_i32,
    __nvvm_match_any_sync_i64,
    __nvvm_mbarrier_arrive,
    __nvvm_mbarrier_arrive_drop,
    __nvvm_mbarrier_arrive_drop_noComplete,
    __nvvm_mbarrier_arrive_drop_noComplete_shared,
    __nvvm_mbarrier_arrive_drop_shared,
    __nvvm_mbarrier_arrive_noComplete,
    __nvvm_mbarrier_arrive_noComplete_shared,
    __nvvm_mbarrier_arrive_shared,
    __nvvm_mbarrier_init,
    __nvvm_mbarrier_init_shared,
    __nvvm_mbarrier_inval,
    __nvvm_mbarrier_inval_shared,
    __nvvm_mbarrier_pending_count,
    __nvvm_mbarrier_test_wait,
    __nvvm_mbarrier_test_wait_shared,
    __nvvm_membar_cta,
    __nvvm_membar_gl,
    __nvvm_membar_sys,
    __nvvm_memcpy,
    __nvvm_memset,
    __nvvm_mul24_i,
    __nvvm_mul24_ui,
    __nvvm_mul_rm_d,
    __nvvm_mul_rm_f,
    __nvvm_mul_rm_ftz_f,
    __nvvm_mul_rn_d,
    __nvvm_mul_rn_f,
    __nvvm_mul_rn_ftz_f,
    __nvvm_mul_rp_d,
    __nvvm_mul_rp_f,
    __nvvm_mul_rp_ftz_f,
    __nvvm_mul_rz_d,
    __nvvm_mul_rz_f,
    __nvvm_mul_rz_ftz_f,
    __nvvm_mulhi_i,
    __nvvm_mulhi_ll,
    __nvvm_mulhi_ui,
    __nvvm_mulhi_ull,
    __nvvm_nanosleep,
    __nvvm_neg_bf16,
    __nvvm_neg_bf16x2,
    __nvvm_pm_event_mask,
    __nvvm_prmt,
    __nvvm_rcp_approx_ftz_d,
    __nvvm_rcp_approx_ftz_f,
    __nvvm_rcp_rm_d,
    __nvvm_rcp_rm_f,
    __nvvm_rcp_rm_ftz_f,
    __nvvm_rcp_rn_d,
    __nvvm_rcp_rn_f,
    __nvvm_rcp_rn_ftz_f,
    __nvvm_rcp_rp_d,
    __nvvm_rcp_rp_f,
    __nvvm_rcp_rp_ftz_f,
    __nvvm_rcp_rz_d,
    __nvvm_rcp_rz_f,
    __nvvm_rcp_rz_ftz_f,
    __nvvm_read_ptx_sreg_clock,
    __nvvm_read_ptx_sreg_clock64,
    __nvvm_read_ptx_sreg_cluster_ctaid_w,
    __nvvm_read_ptx_sreg_cluster_ctaid_x,
    __nvvm_read_ptx_sreg_cluster_ctaid_y,
    __nvvm_read_ptx_sreg_cluster_ctaid_z,
    __nvvm_read_ptx_sreg_cluster_ctarank,
    __nvvm_read_ptx_sreg_cluster_nctaid_w,
    __nvvm_read_ptx_sreg_cluster_nctaid_x,
    __nvvm_read_ptx_sreg_cluster_nctaid_y,
    __nvvm_read_ptx_sreg_cluster_nctaid_z,
    __nvvm_read_ptx_sreg_cluster_nctarank,
    __nvvm_read_ptx_sreg_clusterid_w,
    __nvvm_read_ptx_sreg_clusterid_x,
    __nvvm_read_ptx_sreg_clusterid_y,
    __nvvm_read_ptx_sreg_clusterid_z,
    __nvvm_read_ptx_sreg_ctaid_w,
    __nvvm_read_ptx_sreg_ctaid_x,
    __nvvm_read_ptx_sreg_ctaid_y,
    __nvvm_read_ptx_sreg_ctaid_z,
    __nvvm_read_ptx_sreg_globaltimer,
    __nvvm_read_ptx_sreg_gridid,
    __nvvm_read_ptx_sreg_laneid,
    __nvvm_read_ptx_sreg_lanemask_eq,
    __nvvm_read_ptx_sreg_lanemask_ge,
    __nvvm_read_ptx_sreg_lanemask_gt,
    __nvvm_read_ptx_sreg_lanemask_le,
    __nvvm_read_ptx_sreg_lanemask_lt,
    __nvvm_read_ptx_sreg_nclusterid_w,
    __nvvm_read_ptx_sreg_nclusterid_x,
    __nvvm_read_ptx_sreg_nclusterid_y,
    __nvvm_read_ptx_sreg_nclusterid_z,
    __nvvm_read_ptx_sreg_nctaid_w,
    __nvvm_read_ptx_sreg_nctaid_x,
    __nvvm_read_ptx_sreg_nctaid_y,
    __nvvm_read_ptx_sreg_nctaid_z,
    __nvvm_read_ptx_sreg_nsmid,
    __nvvm_read_ptx_sreg_ntid_w,
    __nvvm_read_ptx_sreg_ntid_x,
    __nvvm_read_ptx_sreg_ntid_y,
    __nvvm_read_ptx_sreg_ntid_z,
    __nvvm_read_ptx_sreg_nwarpid,
    __nvvm_read_ptx_sreg_pm0,
    __nvvm_read_ptx_sreg_pm1,
    __nvvm_read_ptx_sreg_pm2,
    __nvvm_read_ptx_sreg_pm3,
    __nvvm_read_ptx_sreg_smid,
    __nvvm_read_ptx_sreg_tid_w,
    __nvvm_read_ptx_sreg_tid_x,
    __nvvm_read_ptx_sreg_tid_y,
    __nvvm_read_ptx_sreg_tid_z,
    __nvvm_read_ptx_sreg_warpid,
    __nvvm_read_ptx_sreg_warpsize,
    __nvvm_redux_sync_add,
    __nvvm_redux_sync_and,
    __nvvm_redux_sync_fmax,
    __nvvm_redux_sync_fmax_NaN,
    __nvvm_redux_sync_fmax_abs,
    __nvvm_redux_sync_fmax_abs_NaN,
    __nvvm_redux_sync_fmin,
    __nvvm_redux_sync_fmin_NaN,
    __nvvm_redux_sync_fmin_abs,
    __nvvm_redux_sync_fmin_abs_NaN,
    __nvvm_redux_sync_max,
    __nvvm_redux_sync_min,
    __nvvm_redux_sync_or,
    __nvvm_redux_sync_umax,
    __nvvm_redux_sync_umin,
    __nvvm_redux_sync_xor,
    __nvvm_reflect,
    __nvvm_round_d,
    __nvvm_round_f,
    __nvvm_round_ftz_f,
    __nvvm_rsqrt_approx_d,
    __nvvm_rsqrt_approx_f,
    __nvvm_rsqrt_approx_ftz_f,
    __nvvm_sad_i,
    __nvvm_sad_ui,
    __nvvm_saturate_d,
    __nvvm_saturate_f,
    __nvvm_saturate_ftz_f,
    __nvvm_shfl_bfly_f32,
    __nvvm_shfl_bfly_i32,
    __nvvm_shfl_down_f32,
    __nvvm_shfl_down_i32,
    __nvvm_shfl_idx_f32,
    __nvvm_shfl_idx_i32,
    __nvvm_shfl_sync_bfly_f32,
    __nvvm_shfl_sync_bfly_i32,
    __nvvm_shfl_sync_down_f32,
    __nvvm_shfl_sync_down_i32,
    __nvvm_shfl_sync_idx_f32,
    __nvvm_shfl_sync_idx_i32,
    __nvvm_shfl_sync_up_f32,
    __nvvm_shfl_sync_up_i32,
    __nvvm_shfl_up_f32,
    __nvvm_shfl_up_i32,
    __nvvm_sin_approx_f,
    __nvvm_sin_approx_ftz_f,
    __nvvm_sqrt_approx_f,
    __nvvm_sqrt_approx_ftz_f,
    __nvvm_sqrt_rm_d,
    __nvvm_sqrt_rm_f,
    __nvvm_sqrt_rm_ftz_f,
    __nvvm_sqrt_rn_d,
    __nvvm_sqrt_rn_f,
    __nvvm_sqrt_rn_ftz_f,
    __nvvm_sqrt_rp_d,
    __nvvm_sqrt_rp_f,
    __nvvm_sqrt_rp_ftz_f,
    __nvvm_sqrt_rz_d,
    __nvvm_sqrt_rz_f,
    __nvvm_sqrt_rz_ftz_f,
    __nvvm_trunc_d,
    __nvvm_trunc_f,
    __nvvm_trunc_ftz_f,
    __nvvm_ue8m0x2_to_bf16x2,
    __nvvm_ui2d_rm,
    __nvvm_ui2d_rn,
    __nvvm_ui2d_rp,
    __nvvm_ui2d_rz,
    __nvvm_ui2f_rm,
    __nvvm_ui2f_rn,
    __nvvm_ui2f_rp,
    __nvvm_ui2f_rz,
    __nvvm_ull2d_rm,
    __nvvm_ull2d_rn,
    __nvvm_ull2d_rp,
    __nvvm_ull2d_rz,
    __nvvm_ull2f_rm,
    __nvvm_ull2f_rn,
    __nvvm_ull2f_rp,
    __nvvm_ull2f_rz,
    __nvvm_vote_all,
    __nvvm_vote_all_sync,
    __nvvm_vote_any,
    __nvvm_vote_any_sync,
    __nvvm_vote_ballot,
    __nvvm_vote_ballot_sync,
    __nvvm_vote_uni,
    __nvvm_vote_uni_sync,
    __syncthreads,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 10;
pub const longest_name = 45;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(1614);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 807, .child_index = 2 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 807, .child_index = 3 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 22, .child_index = 10 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 12 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 30, .child_index = 13 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 32, .child_index = 14 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 15 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 703, .child_index = 16 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 17 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 18 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 19 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 20 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 21 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 32, .child_index = 22 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 23 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 703, .child_index = 24 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 25 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 26 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 27 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 28 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 29 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 32, .child_index = 30 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 31 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 703, .child_index = 32 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 33 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 34 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 35 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 36 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 37 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 32, .child_index = 38 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 39 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 703, .child_index = 42 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 43 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 44 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 45 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 46 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 47 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 32, .child_index = 48 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 49 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 50 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 51 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 703, .child_index = 52 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 69 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 70 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 71 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 72 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 73 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 32, .child_index = 76 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 79 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 80 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 81 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 123, .child_index = 82 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 86 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 88 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 40, .child_index = 91 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 93 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 188, .child_index = 98 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 106 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 107 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 84, .child_index = 109 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 44, .child_index = 113 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 117 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 119 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 90, .child_index = 121 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 37, .child_index = 125 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 129 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 17, .child_index = 130 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 133 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 134 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 135 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 136 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 137 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 138 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 139 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 140 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 141 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 142 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 143 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 144 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 145 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 146 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 147 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 148 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 149 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 108, .child_index = 150 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 151 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 152 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 153 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 154 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 156 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 157 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 161 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 162 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 163 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 164 },
    .{ .char = '5', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 163 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 165 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 167 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 48, .child_index = 168 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 174 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 175 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 22, .child_index = 176 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 178 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 102, .child_index = 179 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 182 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 183 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 185 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 72, .child_index = 187 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 189 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 190 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 191 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 192 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 15, .child_index = 194 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 195 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 196 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 197 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 198 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 199 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 200 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 201 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 70, .child_index = 202 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 205 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 206 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 207 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 209 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 210 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 211 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 212 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 213 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 190 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 214 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 215 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 216 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 217 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 218 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 219 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 220 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 221 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 222 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 223 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 224 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 225 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 227 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 228 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 229 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 232 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 108, .child_index = 233 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 234 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 237 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 238 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 239 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 240 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 241 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 242 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 243 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 244 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 245 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 247 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 248 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 250 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 251 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 252 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 254 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 255 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 256 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 242 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 257 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 258 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 259 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 261 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 263 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 265 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 266 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 65, .child_index = 267 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 269 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 270 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 271 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 271 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 272 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 273 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 36, .child_index = 274 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 36, .child_index = 274 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 275 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 183 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 276 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 277 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 278 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 279 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 280 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 283 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 286 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 287 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 288 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 53, .child_index = 289 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 290 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 291 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 292 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 293 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 294 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 296 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 240 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 297 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 298 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 299 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 190 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 300 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 301 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 302 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 303 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 304 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 305 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 306 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 307 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 308 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 309 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 310 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 311 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 312 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 314 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 315 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 316 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 317 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 108, .child_index = 318 },
    .{ .char = '0', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 319 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 320 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 322 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 323 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 325 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 326 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 327 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 328 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 329 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 271 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 271 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 244 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 332 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 334 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 334 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 334 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 334 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 335 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 336 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 337 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 338 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 242 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 339 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 242 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 257 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 340 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 342 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 343 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 344 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 345 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 28, .child_index = 346 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 347 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 347 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 348 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 349 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 351 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 36, .child_index = 352 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 360 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 361 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 362 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 363 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 364 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 365 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 366 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 367 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 368 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 317 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 369 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 371 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 372 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 374 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 375 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 377 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 378 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 379 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 381 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 382 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 247 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 383 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 385 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 386 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 387 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 388 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 389 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 390 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 391 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 391 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 392 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 393 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 393 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 394 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 395 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 399 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 400 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 401 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 402 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 108, .child_index = 406 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 414 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 417 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 418 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 419 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 420 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 421 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 423 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 424 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 425 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 426 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 430 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 431 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 432 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 424 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 402 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 436 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 437 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 438 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 439 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 440 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 441 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 442 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 343 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 445 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 446 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 447 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 451 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 456 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 432 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 457 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 458 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 459 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 461 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 459 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 461 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 459 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 4, .child_index = 462 },
    .{ .char = 's', .end_of_word = true, .end_of_list = false, .number = 6, .child_index = 464 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 467 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 471 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 472 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 473 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 474 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 475 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 476 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 477 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 294 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 478 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 479 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 480 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 481 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 402 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 482 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 483 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 484 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 275 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 485 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 486 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = '0', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 491 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 492 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 495 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 496 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 497 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 391 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 498 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 393 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 499 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 500 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 501 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 502 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 503 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 504 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 505 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 324 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 324 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 324 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 508 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 39, .child_index = 510 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 512 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 513 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 514 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 516 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 38, .child_index = 517 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 519 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 521 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 522 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 523 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 524 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 525 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 526 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 527 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 528 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 529 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 530 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 531 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 532 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 532 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 532 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 532 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 533 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 534 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 535 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 536 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 532 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 537 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 6, .child_index = 538 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 540 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 541 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 542 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 324 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 19, .child_index = 544 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 324 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 19, .child_index = 545 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 547 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 548 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 549 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 550 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 551 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 461 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 459 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 459 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 459 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 4, .child_index = 462 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 459 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 552 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 553 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 555 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 556 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 557 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 558 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 561 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 562 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 563 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 564 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 565 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 566 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 567 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 568 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 569 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 570 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 571 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 572 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 573 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 575 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 576 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 577 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 578 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 581 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 584 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 585 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 586 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 587 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 588 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 589 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 590 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 591 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 592 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 593 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 594 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 595 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 596 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 35, .child_index = 597 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 598 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 598 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 599 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 600 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 601 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 602 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 35, .child_index = 603 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 604 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 516 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 606 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 607 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 608 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 609 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 610 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 611 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 612 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 613 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 614 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 615 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 616 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 617 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 618 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 619 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 620 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 592 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 621 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 622 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 623 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 624 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 628 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 19, .child_index = 629 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 592 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 634 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 635 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 636 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 637 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 638 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 639 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 640 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 641 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 642 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 644 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 645 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 648 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 649 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 651 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 652 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 653 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 654 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 655 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 656 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 657 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 658 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 659 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 660 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 661 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 662 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 663 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 664 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 665 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 666 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 667 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 668 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 669 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 670 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 671 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 672 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 673 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 674 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 675 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 676 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 679 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 680 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 681 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 683 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 684 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 685 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 686 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 601 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 687 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 35, .child_index = 688 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 689 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 690 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 690 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 691 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 601 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 35, .child_index = 688 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 692 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 607 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 693 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 694 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 696 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 697 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 698 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 699 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 700 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 701 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 702 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 703 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 704 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 705 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 707 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 709 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 710 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 536 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 711 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 712 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 713 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 714 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 715 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 10, .child_index = 716 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 718 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 719 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 720 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 721 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 722 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 723 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 724 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 725 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 726 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 727 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 728 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 729 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 730 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 731 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 648 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 732 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 648 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 733 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 734 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 735 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 736 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 737 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 738 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 739 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 661 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 740 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 741 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 743 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 744 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 744 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 745 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 744 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 746 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 749 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 750 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 751 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 752 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 753 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 754 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 755 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 758 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 761 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 762 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 763 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 764 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 765 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 765 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 766 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 767 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 768 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 769 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 770 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 771 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 35, .child_index = 772 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 779 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 780 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 781 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 601 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 782 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 783 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 784 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 785 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 786 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 787 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 789 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 790 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 793 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 794 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 795 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 796 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 797 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 797 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = false, .number = 6, .child_index = 798 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 800 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 801 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 802 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 803 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 805 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 806 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 807 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 808 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 592 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 809 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 810 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 811 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 812 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 816 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 819 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 820 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 821 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 822 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 826 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 827 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 828 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 829 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 830 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 834 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 835 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 836 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 837 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 661 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 661 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 838 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 839 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 839 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 840 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 782 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 841 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 842 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 843 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 763 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 844 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 845 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 846 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 847 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 851 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 852 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 853 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 854 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 855 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 856 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 763 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 857 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 858 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 859 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 765 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 860 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 861 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 862 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 863 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 864 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 508 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 865 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 512 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 513 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 514 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 516 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 519 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 866 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 867 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 868 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 417 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 869 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 870 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 871 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 872 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 873 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 874 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 875 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 878 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 879 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 880 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 881 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 882 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 884 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 885 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 887 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 885 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 888 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 889 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 890 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 890 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 890 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 891 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 891 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 892 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 893 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 894 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 895 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 888 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 896 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 897 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 888 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 548 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 898 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 362 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 899 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 900 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 901 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 902 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 903 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 324 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 904 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 905 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 906 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 907 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 908 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 909 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 910 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 911 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 912 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 913 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 914 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 768 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 918 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 919 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 920 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 921 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 922 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 923 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 924 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 925 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 926 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 927 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 928 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 929 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 930 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 931 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 934 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 935 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 936 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 937 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 938 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 939 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 940 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 596 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 941 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 942 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 943 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 944 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 945 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 628 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 946 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 947 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 948 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 949 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 950 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 951 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 952 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 953 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 954 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 955 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 713 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 714 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 957 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 958 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 959 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 960 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 592 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 961 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 962 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 963 },
    .{ .char = '0', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 964 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 965 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 968 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 400 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 969 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 970 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 971 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 710 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 972 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 973 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 974 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 975 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 710 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 976 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 977 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 978 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 979 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 981 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 982 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 983 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 984 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 985 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 567 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 568 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 569 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 571 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 991 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 744 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 992 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 995 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 996 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 997 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 998 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 999 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1000 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1003 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1004 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1005 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1008 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 934 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 934 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1009 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1011 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1012 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1013 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1014 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1015 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1016 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1017 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1018 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1019 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1021 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1022 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1023 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1024 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 528 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1025 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1026 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1027 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1028 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1029 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1030 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1031 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1033 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1034 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1035 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 959 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1036 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1037 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1038 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1039 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 888 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1040 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 719 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1041 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1043 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1044 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1045 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1046 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1047 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1048 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1049 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1050 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1051 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1052 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1053 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1054 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1055 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1056 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1057 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 1058 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1059 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 1061 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1062 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 522 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1064 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1023 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1065 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1066 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1066 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1067 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1069 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1070 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1071 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1072 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1073 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1074 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1073 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1008 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1008 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1075 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1072 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1072 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1077 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1078 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1080 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1081 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1083 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1087 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1090 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1091 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1094 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1095 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1096 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1097 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1098 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1099 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1100 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1101 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 891 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 592 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 611 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1102 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1103 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1104 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1105 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1106 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1107 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1108 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1109 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1110 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1113 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1114 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1048 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 648 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1115 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1116 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1117 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1118 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1120 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1121 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1122 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1123 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 1124 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 605 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1125 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1127 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1024 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1062 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1128 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1129 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1130 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1131 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1132 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1133 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1134 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1135 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1136 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1138 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1138 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 839 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1139 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1140 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 839 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 671 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1140 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1094 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 1094 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 1094 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1019 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1141 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1142 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1143 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1144 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1145 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1146 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1147 },
    .{ .char = 'u', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 887 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1149 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1150 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1151 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1152 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1153 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1154 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 888 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 897 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1155 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1156 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1157 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1158 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1159 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1160 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1161 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1162 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1163 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1164 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 1165 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1173 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1174 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1175 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1176 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1177 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1178 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1179 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1180 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1181 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1182 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1184 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1185 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1186 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1187 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1188 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1189 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1190 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1191 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1192 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1193 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1194 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1195 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1196 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 797 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1197 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 895 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1199 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1200 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1201 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1202 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1203 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 8, .child_index = 1204 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1205 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1206 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1207 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1208 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 20, .child_index = 1210 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1212 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1214 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 1215 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1219 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1220 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1221 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1222 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1223 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1223 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1224 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1225 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1225 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1226 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1227 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1228 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1229 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 768 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1135 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1135 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1230 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1013 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1232 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1234 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1235 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1236 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1237 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 648 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1238 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1239 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1240 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 887 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 887 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1242 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1243 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 802 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1244 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1246 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 1248 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1251 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1252 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1253 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 1254 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1256 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1257 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1258 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1259 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 1260 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1220 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1221 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1262 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1263 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1267 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1268 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1269 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1270 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 768 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1272 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1273 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1277 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1279 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1280 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1281 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1282 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1283 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1194 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1284 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1285 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1286 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1287 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 959 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1288 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1289 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1291 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1292 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 768 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1072 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1293 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1294 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1205 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1295 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1296 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1053 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1297 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1298 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1221 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1299 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1300 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1301 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1302 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1256 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1303 },
    .{ .char = '0', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '3', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1304 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1305 },
    .{ .char = 'N', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1306 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1307 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1308 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1309 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1310 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1311 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1312 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1313 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1313 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1314 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1315 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1316 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1317 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1318 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1319 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 733 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1320 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1321 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1322 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 400 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 888 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 733 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 733 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1323 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1324 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1325 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1326 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1327 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1328 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1329 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1267 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1330 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1332 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1333 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1334 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1338 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1340 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1341 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1342 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1343 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1344 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1345 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1346 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1347 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1349 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1350 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1351 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1352 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1353 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1354 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1355 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1356 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1357 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1358 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1359 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1360 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1361 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 605 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1362 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1363 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1267 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 605 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1364 },
    .{ .char = 'N', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1365 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1366 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1367 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1368 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1369 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1368 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1370 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1370 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1372 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1375 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1376 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1377 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1378 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1379 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 709 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1380 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1381 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1142 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1072 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1382 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1383 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1384 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1385 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1386 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1387 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1066 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1388 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1389 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1390 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1391 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1391 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1391 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1391 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1392 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1393 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1394 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1395 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1396 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 960 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1397 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1399 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1400 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1402 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1403 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1404 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1320 },
    .{ .char = 'N', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1306 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1405 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1392 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1406 },
    .{ .char = '_', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1391 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1407 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1408 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1409 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1410 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1294 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1205 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1411 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 1412 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1268 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1414 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1415 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1221 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1416 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1392 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1417 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1418 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1419 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1420 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1421 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 1422 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1423 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1150 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1424 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1427 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1428 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1429 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1430 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1431 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1432 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1433 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1422 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1434 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1435 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1435 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1437 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1439 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1440 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1441 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1442 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1444 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 1445 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1447 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1448 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1449 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1450 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1453 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1454 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1205 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1268 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1455 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1456 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1457 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1458 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1229 },
    .{ .char = '4', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1229 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1459 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1460 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1461 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1462 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1325 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1463 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 769 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1464 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1465 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1466 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1467 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1392 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1468 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1469 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1470 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1392 },
};
pub const data = blk: {
    @setEvalBranchQuota(7263);
    break :blk [_]Properties{
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*Ii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*Ii", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "V4fiiff" },
        .{ .param_str = "V4fiiii" },
        .{ .param_str = "V4iiiff" },
        .{ .param_str = "V4iiiii" },
        .{ .param_str = "V4fiiffff" },
        .{ .param_str = "V4fiiiiii" },
        .{ .param_str = "V4iiiffff" },
        .{ .param_str = "V4iiiiiii" },
        .{ .param_str = "viiiffff" },
        .{ .param_str = "viiiiiii" },
        .{ .param_str = "viiiUiUiUiUi" },
        .{ .param_str = "vd*dC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vd*dC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vd*dC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vd*dC*dC*dC*IiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vd*dC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*iC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*iC*iC*IiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vi*iC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*fC*UiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vf*iC*iC*fC*IiIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Ui", .features = "ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddD*d", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ffD*f" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "iiD*ii" },
        .{ .param_str = "LiLiD*LiLi" },
        .{ .param_str = "LLiLLiD*LLiLLi" },
        .{ .param_str = "UsUsD*UsUs", .features = "sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ddD*d", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ffD*f", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*ii", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*LiLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLiLLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UsUsD*UsUs", .features = "sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULiULiD*ULi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULLiULLiD*ULLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULiULiD*ULi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULLiULLiD*ULLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui" },
        .{ .param_str = "UiUiD*Ui" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "UiUiD*Ui" },
        .{ .param_str = "ULiULiD*ULi" },
        .{ .param_str = "ULLiULLiD*ULLi" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "UiUiD*Ui" },
        .{ .param_str = "ULiULiD*ULi" },
        .{ .param_str = "ULLiULLiD*ULLi" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "ddD*d", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ffD*f", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*ii", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*LiLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLiLLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UsUsD*UsUs", .features = "sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULiULiD*ULi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULLiULLiD*ULLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "UiUiD*Ui", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULiULiD*ULi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "ULLiULLiD*ULLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LiLiD*Li", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "LLiLLiD*LLi", .features = "sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "iiD*i" },
        .{ .param_str = "LiLiD*Li" },
        .{ .param_str = "LLiLLiD*LLi" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "ii" },
        .{ .param_str = "vi" },
        .{ .param_str = "vUi", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "v", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vUi", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "vUiUi", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "sV2y", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sV2y", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sV2y", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sV2y", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "vcC*4" },
        .{ .param_str = "vcC*4" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "vv*3vC*1.", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vv*3vC*1.", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vv*3vC*1.", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vv*3vC*1.", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*3", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*3", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vIi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "fd" },
        .{ .param_str = "id" },
        .{ .param_str = "id" },
        .{ .param_str = "id" },
        .{ .param_str = "id" },
        .{ .param_str = "id" },
        .{ .param_str = "id" },
        .{ .param_str = "LLid" },
        .{ .param_str = "LLid" },
        .{ .param_str = "LLid" },
        .{ .param_str = "LLid" },
        .{ .param_str = "Uid" },
        .{ .param_str = "Uid" },
        .{ .param_str = "Uid" },
        .{ .param_str = "Uid" },
        .{ .param_str = "ULLid" },
        .{ .param_str = "ULLid" },
        .{ .param_str = "ULLid" },
        .{ .param_str = "ULLid" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hs", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "hh", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2h", .features = "(sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ff" },
        .{ .param_str = "v" },
        .{ .param_str = "sV2h", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sV2h", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sV2h", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sV2h", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yf", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yf", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yf", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yf", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Usf" },
        .{ .param_str = "Usf" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "if" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "LLif" },
        .{ .param_str = "Zif", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "Zif", .features = "(sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "Uif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "ULLif" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "hh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ff" },
        .{ .param_str = "hh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "sff", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dddd" },
        .{ .param_str = "ffff" },
        .{ .param_str = "ffff" },
        .{ .param_str = "yyyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "dddd" },
        .{ .param_str = "ffff" },
        .{ .param_str = "hhhh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ffff" },
        .{ .param_str = "hhhh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhhh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhhh", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2hV2h", .features = "(sm_53|sm_60|sm_61|sm_62|sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx42|ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "dddd" },
        .{ .param_str = "ffff" },
        .{ .param_str = "ffff" },
        .{ .param_str = "dddd" },
        .{ .param_str = "ffff" },
        .{ .param_str = "ffff" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yyy", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2yV2y", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "fff", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "hhh", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2hV2hV2h", .features = "(sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUiUii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "iv*", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iv*3", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "di" },
        .{ .param_str = "di" },
        .{ .param_str = "di" },
        .{ .param_str = "di" },
        .{ .param_str = "fi" },
        .{ .param_str = "fi" },
        .{ .param_str = "fi" },
        .{ .param_str = "fi" },
        .{ .param_str = "b", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ccC*" },
        .{ .param_str = "E2cE2cC*" },
        .{ .param_str = "E4cE4cC*" },
        .{ .param_str = "ddC*" },
        .{ .param_str = "E2dE2dC*" },
        .{ .param_str = "ffC*" },
        .{ .param_str = "E2fE2fC*" },
        .{ .param_str = "E4fE4fC*" },
        .{ .param_str = "hhC*" },
        .{ .param_str = "E2hE2hC*" },
        .{ .param_str = "iiC*" },
        .{ .param_str = "E2iE2iC*" },
        .{ .param_str = "E4iE4iC*" },
        .{ .param_str = "LiLiC*" },
        .{ .param_str = "E2LiE2LiC*" },
        .{ .param_str = "LLiLLiC*" },
        .{ .param_str = "E2LLiE2LLiC*" },
        .{ .param_str = "ssC*" },
        .{ .param_str = "E2sE2sC*" },
        .{ .param_str = "E4sE4sC*" },
        .{ .param_str = "ScScC*" },
        .{ .param_str = "E2ScE2ScC*" },
        .{ .param_str = "E4ScE4ScC*" },
        .{ .param_str = "UcUcC*" },
        .{ .param_str = "E2UcE2UcC*" },
        .{ .param_str = "E4UcE4UcC*" },
        .{ .param_str = "UiUiC*" },
        .{ .param_str = "E2UiE2UiC*" },
        .{ .param_str = "E4UiE4UiC*" },
        .{ .param_str = "ULiULiC*" },
        .{ .param_str = "E2ULiE2ULiC*" },
        .{ .param_str = "ULLiULLiC*" },
        .{ .param_str = "E2ULLiE2ULLiC*" },
        .{ .param_str = "UsUsC*" },
        .{ .param_str = "E2UsE2UsC*" },
        .{ .param_str = "E4UsE4UsC*" },
        .{ .param_str = "ccC*" },
        .{ .param_str = "E2cE2cC*" },
        .{ .param_str = "E4cE4cC*" },
        .{ .param_str = "ddC*" },
        .{ .param_str = "E2dE2dC*" },
        .{ .param_str = "ffC*" },
        .{ .param_str = "E2fE2fC*" },
        .{ .param_str = "E4fE4fC*" },
        .{ .param_str = "hhC*" },
        .{ .param_str = "E2hE2hC*" },
        .{ .param_str = "iiC*" },
        .{ .param_str = "E2iE2iC*" },
        .{ .param_str = "E4iE4iC*" },
        .{ .param_str = "LiLiC*" },
        .{ .param_str = "E2LiE2LiC*" },
        .{ .param_str = "LLiLLiC*" },
        .{ .param_str = "E2LLiE2LLiC*" },
        .{ .param_str = "ssC*" },
        .{ .param_str = "E2sE2sC*" },
        .{ .param_str = "E4sE4sC*" },
        .{ .param_str = "ScScC*" },
        .{ .param_str = "E2ScE2ScC*" },
        .{ .param_str = "E4ScE4ScC*" },
        .{ .param_str = "UcUcC*" },
        .{ .param_str = "E2UcE2UcC*" },
        .{ .param_str = "E4UcE4UcC*" },
        .{ .param_str = "UiUiC*" },
        .{ .param_str = "E2UiE2UiC*" },
        .{ .param_str = "E4UiE4UiC*" },
        .{ .param_str = "ULiULiC*" },
        .{ .param_str = "E2ULiE2ULiC*" },
        .{ .param_str = "ULLiULLiC*" },
        .{ .param_str = "E2ULLiE2ULLiC*" },
        .{ .param_str = "UsUsC*" },
        .{ .param_str = "E2UsE2UsC*" },
        .{ .param_str = "E4UsE4UsC*" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dLLi" },
        .{ .param_str = "dLLi" },
        .{ .param_str = "dLLi" },
        .{ .param_str = "dLLi" },
        .{ .param_str = "fLLi" },
        .{ .param_str = "fLLi" },
        .{ .param_str = "fLLi" },
        .{ .param_str = "fLLi" },
        .{ .param_str = "dii" },
        .{ .param_str = "v*v*i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v*3v*3i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUiUii*", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUiWii*", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUiUi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUiWi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*3i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*3", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*3i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "WiWi*3", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*3i", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vWi*3", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iWi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "bWi*Wi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "bWi*3Wi", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "vUc*Uc*zi" },
        .{ .param_str = "vUc*Uczi" },
        .{ .param_str = "iii" },
        .{ .param_str = "UiUiUi" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "ddd" },
        .{ .param_str = "fff" },
        .{ .param_str = "fff" },
        .{ .param_str = "iii" },
        .{ .param_str = "LLiLLiLLi" },
        .{ .param_str = "UiUiUi" },
        .{ .param_str = "ULLiULLiULLi" },
        .{ .param_str = "vUi", .features = "(sm_70|sm_72|sm_75|sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "yy", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "V2yV2y", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "vIUs" },
        .{ .param_str = "UiUiUiUi" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "i" },
        .{ .param_str = "LLi" },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLi" },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .features = "(sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i" },
        .{ .param_str = "i" },
        .{ .param_str = "i" },
        .{ .param_str = "i" },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "i", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "ffi", .features = "(sm_100a),(ptx86|ptx87)" },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UiUii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "iii", .features = "(sm_80|sm_86|sm_87|sm_89|sm_90|sm_90a|sm_100|sm_100a|sm_101|sm_101a|sm_120|sm_120a),(ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87)" },
        .{ .param_str = "UicC*" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "iiii" },
        .{ .param_str = "UiUiUiUi" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "ffii" },
        .{ .param_str = "iiii" },
        .{ .param_str = "ffii" },
        .{ .param_str = "iiii" },
        .{ .param_str = "ffii" },
        .{ .param_str = "iiii" },
        .{ .param_str = "fUifii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "iUiiii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "fUifii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "iUiiii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "fUifii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "iUiiii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "fUifii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "iUiiii", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "ffii" },
        .{ .param_str = "iiii" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "dd" },
        .{ .param_str = "ff" },
        .{ .param_str = "ff" },
        .{ .param_str = "V2ys", .features = "(sm_100a|sm_101a|sm_120a),(ptx86|ptx87)" },
        .{ .param_str = "dUi" },
        .{ .param_str = "dUi" },
        .{ .param_str = "dUi" },
        .{ .param_str = "dUi" },
        .{ .param_str = "fUi" },
        .{ .param_str = "fUi" },
        .{ .param_str = "fUi" },
        .{ .param_str = "fUi" },
        .{ .param_str = "dULLi" },
        .{ .param_str = "dULLi" },
        .{ .param_str = "dULLi" },
        .{ .param_str = "dULLi" },
        .{ .param_str = "fULLi" },
        .{ .param_str = "fULLi" },
        .{ .param_str = "fULLi" },
        .{ .param_str = "fULLi" },
        .{ .param_str = "bb" },
        .{ .param_str = "bUib", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "bb" },
        .{ .param_str = "bUib", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "Uib" },
        .{ .param_str = "UiUib", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "bb" },
        .{ .param_str = "bUib", .features = "ptx60|ptx61|ptx62|ptx63|ptx64|ptx65|ptx70|ptx71|ptx72|ptx73|ptx74|ptx75|ptx76|ptx77|ptx78|ptx80|ptx81|ptx82|ptx83|ptx84|ptx85|ptx86|ptx87" },
        .{ .param_str = "v" },
    };
};
};
}
