//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    bwx,
    cix,
    fix,
    max,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.bwx)] = .{
        .llvm_name = null,
        .description = "Enable byte/word extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cix)] = .{
        .llvm_name = null,
        .description = "Enable counting extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fix)] = .{
        .llvm_name = null,
        .description = "Enable floating point move and square root extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.max)] = .{
        .llvm_name = null,
        .description = "Enable motion video extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const ev4: CpuModel = .{
        .name = "ev4",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const ev45: CpuModel = .{
        .name = "ev45",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const ev5: CpuModel = .{
        .name = "ev5",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const ev56: CpuModel = .{
        .name = "ev56",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .bwx,
        }),
    };
    pub const ev6: CpuModel = .{
        .name = "ev6",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .bwx,
            .fix,
            .max,
        }),
    };
    pub const ev67: CpuModel = .{
        .name = "ev67",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .bwx,
            .cix,
            .fix,
            .max,
        }),
    };
    pub const pca56: CpuModel = .{
        .name = "pca56",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .bwx,
            .max,
        }),
    };
};
