const common = @import("./common.zig");
const floatFromInt = @import("./float_from_int.zig").floatFromInt;

comptime {
    if (common.want_aeabi) {
        @export(&__aeabi_i2f, .{ .name = "__aeabi_i2f", .linkage = common.linkage, .visibility = common.visibility });
    } else {
        @export(&__floatsisf, .{ .name = "__floatsisf", .linkage = common.linkage, .visibility = common.visibility });
    }
}

pub fn __floatsisf(a: i32) callconv(.c) f32 {
    return floatFromInt(f32, a);
}

fn __aeabi_i2f(a: i32) callconv(.{ .arm_aapcs = .{} }) f32 {
    return floatFromInt(f32, a);
}
